﻿$ErrorActionPreference = "SilentlyContinue"

$ServerInstance = "SharePoint\PowerPivot"
$ExportFolder = "C:\SqlScripts"

# Ładuje złożenie SMO SQL.
[void][System.Reflection.Assembly]::LoadWithPartialName('Microsoft.SqlServer.SMO')
#Create SMO object of SQL Server Instance
$Server = new-object ('Microsoft.SqlServer.Management.Smo.Server') $ServerInstance 

Write-Host "Liczba baz danych: " $Server.Databases.Count -ForegroundColor Yellow

# Iteruje przez listę baz danych w instancji serwera.
# Przegląda iteracyjnie listę baz danych w instancji serwera
ForEach($Database in $Server.Databases)
{
    # Tworzy folder dla każdej bazy danych
    New-Item -ItemType Directory -Path ("$ExportFolder\" + 
        $Database.Name + "\") | Out-Null
    # Tworzy folder dla tabel w folderze każdej bazy danych
    New-Item -ItemType Directory -Path ("$ExportFolder\" + 
        $Database.Name + "\Tables\") | Out-Null
    # Tworzy folder na procedury składowane w folderze każdej bazy danych
    New-Item -ItemType Directory -Path ("$ExportFolder\" + 
        $Database.Name + "\StoredProcedures\") | Out-Null

    # Generuje i eksportuje skrypt bazy danych
    $Database.Script() | Out-File ("$ExportFolder\" + 
        $Database.Name + "\" + $Database.Name + ".sql")

    # Przegląda iteracyjnie listę tabel w każdej bazie danych
    ForEach($table in $Database.Tables)
    {
        # Generuje i eksportuje skrypty tabel
        $table.Script() | Out-File ("$ExportFolder\" + $Database.Name 
            + "\Tables\" + $table.Name + ".sql")
    }

    # Przegląda iteracyjnie listę procedur składowanych w każdej bazie danych
    ForEach($SP in $Database.StoredProcedures)
    {
        # Generuje i eksportuje skrypty procedur składowanych
        $SP.Script() | Out-File ("$ExportFolder\" + $Database.Name + 
            "\StoredProcedures\" + $SP.Name + ".sql")
    }
}
